﻿var results =
{
    url: "",
    reportConfigurationId: 0,
    language: 'en',
    mainSection: null,
    questionNavigator: null,
    questionNavigatorTable: null,
    questionsSection: null,
    questions: new Array(),
    filterSection: null,
    qp: null,
    questionsCount: 0,
    lastQuestionPosition: 0,
    loadedCount: 0
}

$(document).ready(function () {
    loadResultsConfiguation();

    if (results.mainSection.length > 0) {
        bindToggleEvents();
        bindQuestionsPaging();
        bindQuestionNavigator();
        bindQuestionsLoading();
        bindFilter();
        bindLanguages();
        bindOptions();
        //Skip logic
        a4logicEditor.initializeEditors($(".filter-responses", results.filterSection), []);
        a4logicEditor.setVariableAutoCompleteByAjax($(".filter-responses .v-logicEditor", results.filterSection));
    }

});

function printResult() {
    // Load all questions
    var totalCount = $(".h-questionsPager").attr("data-questions-count");

    a4.showBusyBox();

    $.when(loadPagedQuestions($(".h-questionsPager"), null, totalCount)).then(function () {
        $(".lazyBinded[data-loaded='false']").lazyLoad(1000000);

        $.when(waitForQuestionsData()).then(function () {
            a4.hideBusyBox();

            window.print();
        });
    });
}

function waitForQuestionsData() {
    return $.Deferred(function () {
        var self = this;
        var idInterval = null;

        var load = function () {
            if (!a4.ajaxRequestInProcess) {
                clearInterval(idInterval);
                self.resolve();
            }
        }

        idInterval = setInterval(load, 1000);
    });
}

function loadResultsConfiguation() {
    results.mainSection = $(".analyze-results");
    results.questionsSection = $(".v-questions", results.mainSection);
    results.filterSection = $(".v-reportFilter", results.mainSection);

    var configurationSection = $(".v-configuration", results.mainSection);
    results.reportConfigurationId = $("#ReportConfigurationId", configurationSection).val();
    results.language = $("#Language", configurationSection).val();
}

function bindToggleEvents() {
    $(results.mainSection).on("click", ".h-toggleDisplay", function (e) {
        var $t = $(this);

        var $h = $(".v-hiddenContent", $t.parents(".v-toggleContainer"));
        $h.toggle();

        if ($h.is(":visible")) {
            $t.removeClass("no-print");
            $(".fa", $t).removeClass("fa-caret-right");
            $(".fa", $t).addClass("fa-caret-down");
        }
        else {
            $t.addClass("no-print");
            $(".fa", $t).addClass("fa-caret-right");
            $(".fa", $t).removeClass("fa-caret-down");
        }

        var detailedAnswerTable = $(".h-detailedAnswer-table", $h);
        if (detailedAnswerTable.length > 0) {
            bindDetailedAnswerTable(detailedAnswerTable);
        }

        var multiVarDetailedAnswerTable = $(".h-multivar-detailedAnswer-table", $h);
        if (multiVarDetailedAnswerTable.length > 0) {
            loadMultiVariablesDetailedAnswer(multiVarDetailedAnswerTable);
        }
    });
}

function bindQuestionNavigator() {
    $(".v-toggleQuestionNavigatorDisplay", results.mainSection).on("click", function () {
        var navigator = $(".h-questionNavigator", results.mainSection);
        var hide = true;

        if (navigator.is(":visible")) {
            navigator.hide();
            $(".v-right-panel").addClass("full-width").css("width", "100%");
            $(this).removeClass("slide-left").addClass("slide-right");
            $(this).attr("title", resources.ShowQuestionNavigator);
        }
        else {
            navigator.show();
            hide = false;
            $(".v-right-panel").removeClass("full-width");
            var availWidth = ($(window).width() * .98) - 350;
            $(".v-right-panel").css("width", availWidth + "px");

            $(this).attr("title", resources.HideQuestionNavigator);
            $(this).removeClass("slide-right").addClass("slide-left");
        }

        $(this).toggleClass("displayQuestionNavigatorButton");
        $(window).trigger("resize");

        results.hideQuestionPanel = hide;
        a4.callServerMethod(a4.getSurveyAction("UpdateResultsQuestionPanelDisplay", "Analyze"), { reportConfigurationId: results.reportConfigurationId, hideQuestionPanel: hide });
    });

    results.questionNavigator = $(".h-questionNavigator");
    results.questionNavigatorTable = $(".h-questionNavigator-table", results.questionNavigator).a4datatable({
        height: "full",
        ajaxAction: a4.getSurveyAction("GetQuestionsForSelector", "Analyze"),
        ajaxParams: { "reportConfigurationId": results.reportConfigurationId, "language": results.language },
        columns: [
            {
                "Name": "QuestionDefinition", "Title": "", "Data": function (source, type, val) {
                    var jqhtml = $("<div>").append(
                                     $("<div>").addClass("question h-goToQuestion")
                                    .append($("<div>").addClass("name").text(source.Name))
                                    .append($("<div>").addClass("text").text(source.Text))
                                    );

                    return jqhtml.html();
                }
            }
        ],
        localizableTexts: { "Search": resources.SearchQuestions },
        allowRowSelection: true,
        displayColumnSelector: false,
        rowCreated: function (event, d) {
            var currentRow = $(d.row);
            currentRow.data("id", d.data.Id);
            currentRow.data("name", d.data.Name);
            currentRow.data("position", d.data.Position);
            currentRow.data("type", d.data.Type);

            if (d.data.Config.Visible) {
                results.questionNavigatorTable.a4datatable("selectRow", d.index);
            }

            if (d.data.Variables.length > 1) {
                $("td:last", currentRow).append(
                    "<div class=\"variablesSelector\">" +
                    $.map(d.data.Variables, function (val) {
                        return "<div class=\"variable\">"
                                    + "<input type=\"checkbox\" id=\"chkvar" + val.Id + "\" name=\"chkvar" + val.Id
                                            + "\" class=\"selectRow h-selectVariable\" data-id=\"" + val.Id + "\" value=\"" + val.Name + "\""
                                            + (d.data.Config.Visible && !val.NoRender ? " checked " : "") + " />"
                                    + $("<label class=\"name h-goToVariable\"></label>").text(val.Name + " : " + val.Label).html()
                                + "</div>";
                    }).join("")
                    + "</div>"
                );
            }
            else {
                $("td:last", currentRow).append(
                    "<div class=\"variablesSelector\">" +
                    $.map(d.data.Variables, function (val) {
                        return "<input type=\"hidden\" class=\"h-selectHiddenVariable\" id=\"hidvar" + val.Id + "\" name=\"hidvar" + val.Id + "\" data-id=\"" + val.Id + "\" value=\"" + val.Name + "\" />";
                    }).join("")
                    + "</div>"
                );
            }
        }
    });

    $(".h-selectAll", results.questionNavigator).on("click", function () {
        selectAllQuestions();
    });

    $(".h-unselectAll", results.questionNavigator).on("click", function () {
        unselectAllQuestions();
    });

    $(results.questionNavigator).on("click", ".h-selectVariable", function (e) {
        var row = $(this).parents("tr");
        row.toggleClass("selected", getSelectedVariables(row).length > 0);
        changeRowQuestionDisplay(row, true);
    });

    $(results.questionNavigator).on("click", ".selectRow:not(.h-selectVariable)", function (e) {
        var row = $(this).parents("tr");
        $(".h-selectVariable", row).prop("checked", row.hasClass("selected"))
        changeRowQuestionDisplay(row, true);
    });

    $(results.questionNavigator).on("click", ".h-goToQuestion", function (e) {
        var row = $(this).parents("tr");
        if (row.hasClass("selected") || $(".selectRow", row).is(":checked")) {
            scrollTo(row.data("position"));
        }
    });

    $(results.questionNavigator).on("click", ".h-goToVariable", function (e) {
        var questionPosition = $(this).parents("tr").data("position");
        var variableCheckbox = $("input[type=checkbox]", $(this).parent());
        if (variableCheckbox.is(":checked")) {
            var variableId = variableCheckbox.data("id");
            scrollTo(questionPosition, variableId);
        }
    });

    $(".h-backToTop", results.questionNavigator).on("click", function () {
        $('html, body').animate({
            scrollTop: 0
        }, 2000);
    });

    var overAllHeight = 260;
    var padding = 10;
    $(window).on("scroll", function (e) {
        if ($(this).scrollTop() > (overAllHeight - padding) && results.questionNavigator.css('position') != 'fixed') {
            results.questionNavigator.css({ 'position': 'fixed', 'top': padding + 'px' });
            $(".h-backToTop", results.questionNavigator).show();
        }
        else if ($(this).scrollTop() < (overAllHeight - padding) && results.questionNavigator.css('position') != 'absolute') {
            results.questionNavigator.css({ 'position': 'absolute', 'top': 'auto' });
            $(".h-backToTop", results.questionNavigator).hide();
        }
    });
}

function bindQuestionsLoading(section) {
    $(".h-results-question", results.mainSection).each(function () {
        var question = $(this);
        results.questions[question.data("position")] = question;
        bindQuestionLoading();
        $res = $(".v-detailedAnswersToggle", question);

        if (options.ShowDetailedAnswers) {
            $res.lazyLoad().attr("data-loaded", "true");
        }
        else {
            $res.find(".header").addClass("no-print");
            $res.find(".displayIco").removeClass("expanded");
        }

        if (options.ChartType == 0) {
            $(".v-chartControl").removeClass("visible");
            $(".v-chartControl").addClass("hide");
        }
        else {
            $(".v-chartControl").addClass("visible");
            $(".v-chartControl").removeClass("visible");
        }
    });
}

function bindQuestionLoading() {
    $(".h-lazyLoad:not(.lazyBinded)").lazyLoad().removeClass("h-lazyLoad").addClass("lazyBinded");
    $(window).trigger("scroll"); // trigger scroll to lazy load visible things
}

function bindQuestionsPaging() {
    results.qp = $(".h-questionsPager", results.mainSection).first();
    results.questionsCount = results.qp.data("questionsCount");
    results.lastQuestionPosition = results.qp.data("lastPosition");
    results.loadedCount = results.qp.data("loadedCount");

    if (results.loadedCount > results.questionsCount) {
        results.loadedCount = results.questionsCount;
    }

    if (results.lastQuestionPosition == 0 || results.questionsCount < 10) {
        results.qp.hide();
    }
    else {
        results.qp.lazyLoad();
    }
}

function bindFilter() {
    var filterPanel = $(".v-filter-panel", results.mainSection);

    $(".button", $(".h-statusSelector", results.filterSection)).on("click", function () {
        var $b = $(this);
        $(".button").removeClass("selected");
        $b.addClass("selected");
        var selectedVal = $b.attr("data-value");
        $("input[type=hidden]", $b.parents(".h-statusSelector")).val(selectedVal);
        $(".v-custom", results.filterSection).toggle(selectedVal == "Custom");
    });

    $(".h-datepicker", results.filterSection).datepicker();

    $(".h-applyFilter", results.filterSection).on("click", function () {
        var filter = getFilter();

        if (!a4logicEditor.hasError) {
            a4.callServerMethod(a4.getSurveyAction("ApplyResultsFilter", "Analyze"), { reportConfigurationId: results.reportConfigurationId, language: results.language, filterJson: JSON.stringify(filter) },
               function (response) {
                   updateFilterStatus(filter);
                   resetAllVariablesLoadedState();
               });
        }
    });

    $(".h-resetFilter", results.filterSection).on("click", function () {
        a4.callServerMethod(a4.getSurveyAction("ResetResultsFilter", "Analyze"), { reportConfigurationId: results.reportConfigurationId, language: results.language },
           function (response) {
               clearFilter();
               updateFilterStatus(null);
               resetAllVariablesLoadedState();
           });
    });

    results.filterSection.on("click", ".h-deleteRow", function () {
        var item = $(this).closest(".v-questionEditableItem");
        a4logicEditor.replaceItemIndexes(item);
    });
}

function bindLanguages() {
    $(".h-changeDisplayLanguage", results.mainSection).on("change", function () {
        var $t = $(this);
        results.language = $t.val();

        a4.callServerMethod(a4.getSurveyAction("UpdateResultsLanguage", "Analyze"), { reportConfigurationId: results.reportConfigurationId, language: results.language },
           function (response) {
               location.reload(true);
           });
    });
}

function bindOptions() {
    results.mainSection.on("click", ".h-options", function () {
        modalDialog.showWindow(a4.getSurveyAction("ResultsOptions", "Analyze"), 550, 580);
    });
}

function loadPagedQuestions(pager, questionPosition, pSize) {
    var pageSize = pSize || 10;
    if (questionPosition) {
        pageSize = questionPosition - results.loadedCount;
    }

    return a4.callServerMethod(a4.getSurveyAction("GetPagedResultsQuestions", "Analyze"), { reportConfigurationId: results.reportConfigurationId, language: results.language, pageStart: results.loadedCount, pageSize: pageSize },
        function (response) {
            if (response) {
                var currentPager = $(pager);
                var questions = $(response.content);

                results.loadedCount = response.loadedCount;
                results.lastQuestionPosition = response.lastQuestionPosition;

                var lastInsertedElement = changeQuestionsDisplay(questions, currentPager);
                currentPager.insertAfter(lastInsertedElement);

                if (results.questionsCount <= response.loadedCount) {
                    currentPager.hide();
                }
                else {
                    currentPager.lazyLoad();
                }

                results.qp.trigger("deferedScrollingToQuestion");
            }
        });
}

function changeQuestionsDisplay(questions, insertAfterElement) {
    var lastInsertedElement = insertAfterElement;
    questions.each(function (index, value) {
        var question = $(value);
        var position = question.data("position");
        if (position in results.questions) {
            var existingQuestion = results.questions[position];
            existingQuestion.show();
            lastInsertedElement = existingQuestion;
        }
        else {
            if (position > 1) {
                question.insertAfter(lastInsertedElement);
            } else {
                insertAfterElement.prepend(question);
            }

            results.questions[position] = question;
            lastInsertedElement = question;
            bindQuestionLoading();
        }
    });
    return lastInsertedElement;
}

function loadVariablesStatisticsSummary(container) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction("ResultVariablesStatisticsSummary", "Analyze"), {
        questionType: $c.parents(".h-results-question").data("type"),
        variableIds: $c.data("variablesIds"),
        language: results.language,
        variablesType: $c.data("variablesType")
    },
    function (result) {
        $c.html(result.content);
        $c.removeClass("no-print");
        $(".h-multivar-graph").lazyLoad();

        if (options.ChartType == 0) {
            $(".v-detailedAnswersToggle", $c).lazyLoad();
        }

        if (options.ShowDetailedAnswers) {
            lazyLoadDetailedAnswer($c);
        }
    });
}

function loadVariableStats(container) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction("ResultVariableStatistics", "Analyze"), getVariableQueryParams(getQuestionSectionInfo($c), getVariableSectionInfo($c)),
        function (result) {
            $c.html(result.content);
            $c.removeClass("no-print");

            if (options.ChartType == 0) {
                $c.closest(".v-variableDetails").find(".v-detailedAnswersToggle").lazyLoad();
            }
        });
}

function loadNetPromoterScore(container) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction("GetNetPromoterScore", "Analyze"), { questionId: $c.parents(".h-results-question").data("id"), variableName: $c.parents(".v-variableDetails").data("variable-name") },
        function (result) {
            $c.html(result.content);
            $c.removeClass("no-print");
        });
}

function loadFileUploadStats(container) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction("GetFileUploadStatistics", "Analyze"), getVariableQueryParams(getQuestionSectionInfo($c), getVariableSectionInfo($c)),
        function (result) {
            $c.html(result.content);
            $c.removeClass("no-print");

            if (options.ChartType == 0) {
                $c.closest(".v-variableDetails").find(".v-detailedAnswersToggle").lazyLoad();
            }
        });
}

function loadSignatureStats(container) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction("GetSignatureStatistics", "Analyze"), { questionId: $c.parents(".h-results-question").data("id"), variableName: $c.parents(".v-variableDetails").data("variable-name") },
        function (result) {
            $c.html(result.content);
            $c.removeClass("no-print");
        });
}

function bindDetailedAnswerTable(table) {
    var $t = $(table);

    if (!$t.data("loaded")) {
        var questionInfo = getQuestionSectionInfo($t);
        var variableInfo = getVariableSectionInfo($t);

        $t.a4datatable({
            displaySearchBox: false,
            displayColumnSelector: false,
            ajaxAction: a4.getSurveyAction("GetResultsVariableDetailedAnswers", "Analyze"),
            ajaxParams: getVariableQueryParams(questionInfo, variableInfo),
            columns: getColumnByVariable(questionInfo, variableInfo),
            rowCreated: function (event, d) {
                if ((options.ShowChoiceCodes == "True" || options.ShowChoiceCodes == true) && d.data.ChoiceCode) {
                    var choiceCode = $("<span>").append(" (" + d.data.ChoiceCode + ")");
                    choiceCode.addClass("choiceCode");
                    $("td", d.row).first().append(choiceCode);
                }
            },
            footerCreated: function (event, data) {   //", null, { footer: nFoot, data : aData, start : iStart, end : iEnd, display : aiDisplay });                
                if (data.additionalData) {
                    $("tfoot", $(this)).remove();
                    $("table", $(this)).append("<tfoot><tr>"
                        + "<td>" + resources.Total + "</td>"
                        + "<td>" + (data.additionalData["TotalResponses"] || 0) + "</td>"
                        + "</tr></tfoot>");
                }
                if (questionInfo.type == "DragDropRanking" || questionInfo.type == "NumericRanking") {
                    $("div.bottom", $(this)).hide();
                }
            }
        });

        $t.data("loaded", true);
    }
    else if ($t.data("refreshRequired")) {
        $t.a4datatable("refresh", true);
        $t.data("refreshRequired", false);
    }
}

function lazyLoadDetailedAnswer(e) {
    if (options.ShowDetailedAnswers) {
        $(e).find(".h-toggleDisplay").trigger("click");
    }
}

function loadMultiVariablesDetailedAnswer(container) {
    var $c = $(container);

    a4.callServerMethod(a4.getSurveyAction("GetResultsMultipleVariablesDetailedAnswers", "Analyze"), { language: results.language, variableIds: $c.parents(".v-multi-variables").data("variablesIds") },
    function (result) {
        $c.html(result.content);
    });
}

function displayGraph(graph) {
    graph.setAttribute("src", graph.getAttribute("data-src"));
    $(graph).parents(".v-chartControl").removeClass("no-print");
}

function changeRowQuestionDisplay(row, updateConfig) {
    var questionId = row.data("id");
    var questionPosition = row.data("position");
    var questionName = row.data("name");
    var selectedVariables = getSelectedVariables(row);

    var existingQuestion = $(".h-results-question[data-position=" + questionPosition + "]", results.mainSection);
    var isOutOfLoadedRange = isQuestionPaged(questionPosition);

    if (existingQuestion.length == 0 && !isOutOfLoadedRange) {
        var insertAfter = findClosestQuestion(questionPosition);
        var loadingContainer = $("<div>");
        loadingContainer.append("<div class=\"question-loading\"><div class=\"question-name\">" + questionName + "</div>"
                                + "<div class=\"loading-text\">" + voxco.icons.getIcon("loading", "loading-icon") + resources.Loading + "</div></div>");
        if (insertAfter)
            insertAfter.after(loadingContainer);
        else
            results.questionsSection.prepend(loadingContainer);

        results.questions[questionPosition] = loadingContainer;

        a4.callServerMethod(a4.getSurveyAction("GetQuestionResultRender", "Analyze"), {
            reportConfigurationId: results.reportConfigurationId,
            language: results.language,
            questionId: questionId,
            questionName: row.data("name"),
            selectedVariables: getAllVariables(row),
            persistDisplayState: updateConfig
        },
        function (response) {
            var newData = $(response.Content);
            results.questions[response.Position] = newData;
            results.loadedCount++;
            results.questionsCount++;

            loadingContainer.html(newData);

            // load all variables but show only selected
            showSelectedVariableDetails(row, selectedVariables, loadingContainer);

            bindQuestionLoading();

            if (options.ShowDetailedAnswers) {
                $(".v-detailedAnswersToggle", newData).lazyLoad().attr("data-loaded", "true");
            }
        });
    }
    else {
        var isChecked = row.hasClass("selected");

        if (isOutOfLoadedRange) {
            results.qp.show();
            results.qp.lazyLoad();
        }
        else {
            existingQuestion.toggle(isChecked);

            showSelectedVariableDetails(row, selectedVariables, existingQuestion);

            bindQuestionLoading();
        }

        if (options.ShowDetailedAnswers) {
            $(".v-detailedAnswersToggle", existingQuestion).lazyLoad().attr("data-loaded", "true");
        }

        if (updateConfig) {
            a4.callServerMethod(a4.getSurveyAction("UpdateQuestionVisibility", "Analyze"), {
                reportConfigurationId: results.reportConfigurationId,
                questionName: questionName,
                visible: isChecked,
                selectedVariables: selectedVariables
            });
        }
    }
}

function showSelectedVariableDetails(row, selectedVariables, container) {
    $(".v-variableDetails", container).hide();

    $.each(selectedVariables, function (index, variable) {
        var $vd = $(".v-variableDetails[data-variable-name=" + variable + "]", container);
        changeRowVariableDisplay(row, $vd.data("variableId"), true);
    });
}

function changeRowVariableDisplay(row, variableId, show) {
    var variablePlaceholder = $(".v-variableDetails[data-variable-id='" + variableId + "']", results.questions[row.data("position")]);

    if (!variablePlaceholder.data("loaded") == "False") {
        variablePlaceholder.data("loaded", true);

        a4.callServerMethod(a4.getSurveyAction("GetResultsVariableRender", "Analyze"), {
            reportConfigurationId: results.reportConfigurationId,
            language: results.language,
            questionName: row.data("name"),
            variableId: variableId,
            selectedVariables: getSelectedVariables(row)
        },
        function (response) {
            var newData = $($(response.Content).html());
            variablePlaceholder.html(newData);
            bindQuestionLoading();
        });
    }
    else {
        variablePlaceholder.toggle(show);
        bindQuestionLoading();
        a4.callServerMethod(a4.getSurveyAction("UpdateQuestionVisibility", "Analyze"), {
            reportConfigurationId: results.reportConfigurationId,
            questionName: row.data("name"),
            visible: true,
            selectedVariables: getSelectedVariables(row)
        });
    }
}

function getSelectedVariables(row) {
    var selector = ".h-selectVariable:checked";

    if ($(".h-selectHiddenVariable", row).length > 0) {
        selector = ".h-selectHiddenVariable";
    }

    return $.map($(selector, row), function (value, index) {
        return $(value).val();
    });
}

function getAllVariables(row) {
    return $.map($(".h-selectVariable", row), function (value, index) {
        return $(value).val();
    });
}

function getQuestionSectionInfo(section) {
    var qd = $(section).parents(".h-results-question");
    return {
        id: qd.data("id"),
        name: qd.data("name"),
        position: qd.data("position"),
        type: qd.data("type")
    }
}

function getVariableSectionInfo(section) {
    var vd = $(section).parents(".v-variableDetails");
    return {
        id: vd.data("variableId"),
        name: vd.data("variableName"),
        type: vd.data("variableType"),
        multiMention: vd.data("variableMultimention"),
        maxMention: vd.data("variableMaxMention")
    }
}

function getVariableQueryParams(questionSectionInfo, variableSectionInfo) {
    return {
        questionId: questionSectionInfo.id,
        questionName: questionSectionInfo.name,
        questionType: questionSectionInfo.type,
        variableId: variableSectionInfo.id,
        variableName: variableSectionInfo.name,
        variableType: variableSectionInfo.type,
        options: JSON.stringify(options),
        language: results.language
    }
}

function getColumnByVariable(questionInfo, variableInfo) {
    var cols = [];
    if (questionInfo.type == "DragDropRanking" || questionInfo.type == "NumericRanking") {
        cols = [
                { "Name": "Position", "Title": resources.Rank, "Data": "Position", "Sortable": false },
                { "Name": "ChoiceText", "Title": resources.Choice, "Data": "ChoiceText", "Sortable": false },
                { "Name": "AverageRanking", "Title": resources.AverageRanking, "Data": "AverageRanking", "Sortable": false },
                { "Name": "Responses", "Title": resources.NbOfResponses, "Data": "Responses", "Sortable": false }
        ];
    }
    else {
        if (variableInfo.type == "Continuous" || variableInfo.type == "Computed" || (variableInfo.type == "Discrete" && !variableInfo.multiMention)) {
            cols = [
                { "Name": "Answer", "Title": resources.Answer, "Data": "Answer", "Sortable": false, "EncodeHtml": true },
                { "Name": "Frequency", "Title": resources.Frequency, "Data": "Frequency", "Sortable": false },
                { "Name": "Percentage", "Title": resources.Percentage, "Data": "Percent", "Sortable": false },
            ];
        } else if (variableInfo.type == "Discrete") {
            cols = [
                { "Name": "Answer", "Title": resources.Answer, "Data": "Answer", "Sortable": false, "EncodeHtml": true },
                { "Name": "Frequency", "Title": resources.Frequency, "Data": "Frequency", "Sortable": false },
                { "Name": "Percent", "Title": resources.CasesPercent, "Data": "Percent", "Sortable": false }
            ];

            if (variableInfo.maxMention > 1) {
                cols.push({ "Name": "ResponsesPercent", "Title": resources.ResponsesPercent, "Data": "ResponsesPercent", "Sortable": false });
            }
        }
    }
    return cols;
}

function getFilter() {
    var filter = currentFilter;
    if (!filter) filter = new Object();

    filter.InterviewStatus = $(".v-interview-status", results.filterSection).val();

    filter.DateFilterType = $(".h-statusSelector input[type=hidden]", results.filterSection).val();
    if (filter.DateFilterType == "Custom") {
        filter.StartDateFilter = $(".v-filter-date-from", results.filterSection).val();
        filter.EndDateFilter = $(".v-filter-date-to", results.filterSection).val();
    } else {
        filter.StartDateFilter = "";
        filter.EndDateFilter = "";
    }

    filter.ResponsesFilter = a4logicEditor.getLogic($(".filter-responses .v-logicEditor", results.filterSection), true);

    return filter;
}

function clearFilter() {
    $(".v-interview-status", results.filterSection).val("All");

    $(".h-statusSelector .button", results.filterSection).removeClass("selected");
    $(".h-statusSelector .button[data-value='None']", results.filterSection).addClass("selected");
    $(".v-custom", results.filterSection).hide();
    $(".v-custom input", results.filterSection).val("");

    $(".v-filterType", results.filterSection).hide();
    $(".v-logicTable", results.filterSection).hide();
    $(".v-customFilterBlock", results.filterSection).hide();
    $(".v-logicCondition").prop("selectedIndex", 0);
    $(".v-logicTable .v-logicBody tr", results.filterSection).remove();
}

function findClosestQuestion(position) {
    for (var i = position; i >= 0; i--) {
        if (i in results.questions) {
            return results.questions[i];
        }
    }
    return null;
}

function isQuestionPaged(position) {
    return (results.lastQuestionPosition > 0 && results.loadedCount < results.questionsCount && position > results.lastQuestionPosition);
}

function selectAllQuestions() {
    window.scrollTo(0, 0);
    a4.callServerMethod(a4.getSurveyAction("SelectAllResultsQuestions", "Analyze"), { reportConfigurationId: results.reportConfigurationId, language: results.language },
        function (response) {
            results.questionNavigatorTable.a4datatable("setCurrentPage", 0, function () {
                var questions = $(response.content);
                var lastQuestion = changeQuestionsDisplay(questions, $(".h-questionsPager"));

                results.questionsCount = response.questionsCount;
                results.loadedCount = lastQuestion.data("position");
                $(".h-questionsPager").attr("data-questions-count", response.questionsCount);

                if (results.questionsCount > results.loadedCount) {
                    results.questions[results.loadedCount].after(results.qp);
                    results.qp.show();
                    results.qp.lazyLoad();                    
                }
            });            
        });
}

function unselectAllQuestions() {
    results.qp.hide();
    $(".h-results-question", results.mainSection).hide();
    $("input[type=checkbox]", results.questionNavigator).prop("checked", false);
    $(".h-questionNavigator-table tr", results.questionNavigator).removeClass("selected");

    a4.callServerMethod(a4.getSurveyAction("UnselectAllResultsQuestions", "Analyze"), { reportConfigurationId: results.reportConfigurationId }, function (response) {
        results.questionNavigatorTable.a4datatable("setCurrentPage", 0, function () {
            var questions = $(response.content);
            var lastQuestion = changeQuestionsDisplay(questions, $(".h-questionsPager"));

            results.questionsCount = response.questionsCount;
            results.loadedCount = lastQuestion.data("position");
            $(".h-questionsPager").attr("data-questions-count", response.questionsCount);
        });
    });
}

function scrollTo(questionPosition, variableId) {
    var obj = results.questions[questionPosition];

    if (variableId > 0) {
        obj = $(".v-variableDetails[data-variable-id='" + variableId + "']", obj);
    }

    if (obj && obj.length > 0) {
        results.qp && results.qp.unbind("deferedScrollingToQuestion");

        $('html, body').animate({
            scrollTop: obj.offset().top
        }, 2000);
    } else if (questionPosition > 0 || variableId > 0) {
        if (results.qp) {
            loadPagedQuestions(results.qp, questionPosition);
            results.qp.bind("deferedScrollingToQuestion", function () {
                scrollTo(questionPosition, variableId);
            });
        }
    }
}

function resetAllVariablesLoadedState() {
    var $lazy = $(".v-multi-variables[data-loaded=true], .v-statistics[data-loaded=true], .v-hcChart[data-loaded=true]", results.questionsSection);
    $lazy.addClass("no-print");
    $lazy.html(voxco.icons.getIcon("loading", "loading-icon"));
    $lazy.addClass("no-print");

    if (options.ChartType == 0) {
        if (options.ShowDetailedAnswers) {
            $lazy.add($(".v-detailedAnswersToggle"));
        }

        $(".v-chartControl").removeClass("visible");
        $(".v-chartControl").addClass("hide");
    }
    else {
        $(".v-chartControl").addClass("visible");
        $(".v-chartControl").removeClass("hide");
    }

    $(".h-detailedAnswer-table", results.questionsSection).each(function () {
        var table = $(this);

        if (table.data("loaded")) {
            table.data("refreshRequired", true);
            table.parents(".v-hiddenContent").hide();
        }

        var parent = table.closest(".v-detailedAnswersToggle");

        if (options.ShowDetailedAnswers) {
            $(".displayIco", parent).addClass("expanded");
            //parent.lazyLoad();
        }
        else {
            $(".displayIco", parent).removeClass("expanded");

            $(".content", parent).hide();
            $(".header span", parent).addClass("fa-caret-right").removeClass("fa-caret-down");
        }
    });

    $lazy.lazyLoad();
    $lazy.data("loaded", false);
    //bindQuestionLoading();
}

function updateFilterStatus(filter) {
    var label = $(".v-filter-status", results.filterSection.parents(".v-filter-panel"));
    if (filter != null && (filter.InterviewStatus != "All" || filter.DateFilterType != "None" || (filter.ResponsesFilter && filter.ResponsesFilter.Conditions && filter.ResponsesFilter.Conditions.length > 0))) {
        label.html(resources.Active);
    }
    else {
        label.html(resources.NoActiveFilter);
    }
}

function displayMultiVariablesHighGraph(graph) {
    var $g = $(graph);
    var $multiVar = $g.parents(".v-multi-variables");
    var $chartControl = $g.closest(".v-chartControl");

    if (options.ChartType != 0) {
        $chartControl.addClass("visible");
        $g.removeClass("hide");

        a4.callServerMethod(a4.getSurveyAction("GetResultsMultiVariablesChartData", "Analyze"), { variableIds: $multiVar.data("variablesIds"), language: results.language },
        function (chartData) {
            a4.initChart($g, chartData);
        });
    } else {
        $chartControl.removeClass("visible");
        $g.addClass("hide");
    }
}